module net.BurtonRadons.spyl.expression;

private import net.BurtonRadons.spyl.scope;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;

enum Precedence
{
    Expression, /**< "a , b". */
    Assign, /**< "a = b", "a += b", "a -= b", "a *= b", "a /= b", "a %= b", "a **= b", "a &= b", "a |= b", "a ^= b", "a ~= b", "a <<= b", "a >>= b", "a >>>= b". */
    Conditional, /**< "a ? b : c". */
    OrOr, /**< "a || b". */
    AndAnd, /**< "a && b". */
    Or, /**< "a | b". */
    Xor, /**< "a ^ b". */
    And, /**< "a & b". */
    Equal, /**< "a == b", "a != b", "a === b", "a !== b". */
    Relation, /**< "a < b", "a <= b", "a > b", "a >= b", "a !<>= b", "a !<> b", "a <> b", "a !> b", "a !>= b", "a !< b", "a !<= b", "a in b", "a not in b". */
    Shift, /**< "a << b", "a >> b", "a >>> b". */
    Add, /**< "a + b", "a - b", "a ~ b". */
    Multiply, /**< "a * b", "a / b", "a % b". */
    Exponent, /**< "a ** b". */
    Unary, /**< "& a", "++ a", "-- a", "* a", "- a", "+ a", "! a", "~ a", "delete a", "( a )". */
    Postfix, /**< "a . id", "a ++, "a --", "a (b)", "a [b]". */
    Primary, /**< "identifier", literals. */
}

class Expression
{
    Mark mark; /**< Mark for the expression. */
    
    /** Assign the mark. */
    this (Mark mark)
    {
        this.mark = mark;
    }
    
    /** Evaluate the expression and return its value. */
    abstract Value evaluate (Scope scope);
    
    char [] toString ()
    {
        throw new Error (this.classinfo.name ~ ".toString () is not implemented.");
        return null;
    }
    
    /** Return the precedence, for determining whether to put parentheses around the toString. */
    abstract int precedence ();
    
    char [] toString (int precedence)
    {
        if (this.precedence () < precedence)
            return "(" ~ toString () ~ ")";
        return toString ();
    }
    
    char [] subString (Expression other)
    {
        return other.toString (precedence ());
    }
}

import net.BurtonRadons.spyl.expressionAdd;
import net.BurtonRadons.spyl.expressionArray;
import net.BurtonRadons.spyl.expressionAssign;
import net.BurtonRadons.spyl.expressionAttr;
import net.BurtonRadons.spyl.expressionBinary;
import net.BurtonRadons.spyl.expressionCall;
import net.BurtonRadons.spyl.expressionCatenate;
import net.BurtonRadons.spyl.expressionExponent;
import net.BurtonRadons.spyl.expressionIndex;
import net.BurtonRadons.spyl.expressionMultiply;
import net.BurtonRadons.spyl.expressionNegate;
import net.BurtonRadons.spyl.expressionSlice;
import net.BurtonRadons.spyl.expressionSubtract;
import net.BurtonRadons.spyl.expressionSymbol;
import net.BurtonRadons.spyl.expressionUnary;
import net.BurtonRadons.spyl.expressionValue;